// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// GUID for admin and trial period.
//.................................
#include <windows.h>  
#include "Tsc.h"
#include "Prototypes.h"
#include "ContextHelp.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#include <prsht.h>
#define STRSAFE_LIB
#include <strsafe.h>

extern	LPBYTE		lpA1;
extern	LPBYTE		lpPW;
extern	BOOL		bProgramRegistered;
extern	HWND		hMainWindow;
extern	LPCTSTR		lpszNullString;
extern	BOOL		bProcessInProgress;
extern	HINSTANCE	hInst;
extern	LPCTSTR		lpszAppName;
extern	LPCTSTR		lpIconPointer;
extern	LPTSTR		lpszNA;
extern	HWND	    hMyToolBar;
extern	DWORD		dwProcedure;
extern	CONFIG		cfg;
extern	BOOL		bRemoveableMedia;
extern	DWORD		dwRemoveableInstalled;
extern	BOOL		bFirstTimeRead;

// Variables for the various admin entries.
//.........................................
ADMIN_NAME	V2;					
LPCTSTR		lpszV1 = "V1";		// Admin key name

TCHAR		szName[MAX_PATH];
TCHAR		szPP[MAX_PATH];
TCHAR		szTemp[MAX_PATH];
TCHAR		szTemp1[MAX_PATH];
TCHAR		szTemp2[MAX_PATH];

// Variables for the password GUID.
//.................................
LPCTSTR		lpszP1 = "P1";

FILETIME	ftE7;			// current date
SYSTEMTIME	st1;			// 45 days or 225 uses, which ever comes first
DWORD		dwStart;
DWORD		dwLast;
DWORD		dwCurrent;

// We have an active unlimited site license.
//..........................................
BOOL		bAa = FALSE;					// active account created, we can sign in.
BOOL		bSignedIn = FALSE;				// are we signed in.
BOOL		bRestrictionsInEffect = FALSE;	// options are in effect.
BOOL		bNeedUKey = FALSE;				// we need a universal key.
BOOL		bRemainSignedIn;
DWORD		dwTempSettings;
DWORD		dwTempGeneral;
DWORD		dwTempPublic;
DWORD		dwTempSecret;
HWND		hPropertySheet;					// handle to the property sheet.
BOOL		bPsChanged;
TCHAR		szV5[MAX_PATH];
TCHAR		szV6[MAX_PATH];

// Dialog box template names.
//...........................
LPCTSTR		lpAdminGeneral = "ADMINGENERAL";
LPCTSTR		lpAdminPublic = "ADMINPUBLICKEY";
LPCTSTR		lpAdminSecret = "ADMINSECRETKEY";

// This procedure checks to see if we are authorized to run it.
//.............................................................
BOOL ProcedureAuthorized(DWORD dwPermitCode)
{
	BOOL		bAuthorized;
	TCHAR		szString[128];
	TCHAR		szProcedure[128];
	TCHAR		szBuffer[1024];

	if (bAa)
	{
		if (cfg.V1.dwV3 & dwPermitCode || !bRestrictionsInEffect)
		{
			bAuthorized = TRUE;
		}
		else
		{
			// This is not authorized. Get the procedure.
			//...........................................
			LoadString(hInst,dwProcedure,szProcedure,sizeof(szProcedure));

			// Get the message.
			//.................
			LoadString(hInst,IDS_NOTAUTHORIZED,szString,sizeof(szString));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szString,szProcedure);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
						   MB_ICONSTOP | MB_OK,MB_ICONSTOP,0);
			bAuthorized = FALSE;
		}
	}
	else
	{
		bAuthorized = TRUE;
	}
	return(bAuthorized);
}

// Default message for needing a universal key before you can encipher anything.
// Returns TRUE if we have one or we do not need one.
//..............................................................................
BOOL WeHaveAUniversalKey()
{
	if (bAa)
	{
		if (bNeedUKey)
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOUNIVERSALKEY,
						   MB_ICONSTOP | MB_OK,MB_ICONSTOP,0);
			return(FALSE);
		}
		else
		{
			return(TRUE);
		}
	}
	else
	{
		return(TRUE);
	}
}

// Change the administrator settings for this computer.
//.....................................................
VOID SetAdminSettings()
{
	PROPSHEETPAGE		psp[3];
    PROPSHEETHEADER		psh;
	DWORD				dwOldHelpTopic;
	BOOL				bSignedOK;

	ZeroMemory(&psp,sizeof(PROPSHEETPAGE) * 3);
	ZeroMemory(&psh,sizeof(PROPSHEETHEADER));

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_ADMINOPTIONS);
	bSignedOK = bSignedIn;

	// If we are not signed in, we have too.
	//......................................
	if (!bSignedIn)
	{
		bSignedOK = AdminSignIn(FALSE);
	}
	if (bSignedOK)
	{
		// Get a copy of the admin settings.
		//..................................
		dwTempSettings = cfg.V1.dwV3;
		dwTempGeneral = (cfg.V1.dwV3 & GENERAL_MASK);
		dwTempPublic = (cfg.V1.dwV3 & PUBLIC_MASK);
		dwTempSecret = (cfg.V1.dwV3 & SECRET_MASK);
		bPsChanged = FALSE;

		// Setup the first page.
		//......................
		psp[0].dwSize = sizeof(PROPSHEETPAGE);
		psp[0].dwFlags = PSP_HASHELP;
		psp[0].hInstance = hInst;
		psp[0].pszTemplate = lpAdminGeneral;
		psp[0].pfnDlgProc = AdminGeneralProc;
		psp[0].lParam = 0;
		psp[0].pszIcon = NULL;

		// Setup the second page.
		//.......................
		psp[1].dwSize = sizeof(PROPSHEETPAGE);
		psp[1].dwFlags = PSP_HASHELP;
		psp[1].hInstance = hInst;
		psp[1].pszTemplate = lpAdminPublic;
		psp[1].pfnDlgProc = AdminPublicKeyProc;
		psp[1].lParam = 0;
		psp[1].pszIcon = NULL;

		// Setup the third page.
		//......................
		psp[2].dwSize = sizeof(PROPSHEETPAGE);
		psp[2].dwFlags = PSP_HASHELP;
		psp[2].hInstance = hInst;
		psp[2].pszTemplate = lpAdminSecret;
		psp[2].pfnDlgProc = AdminSecretKeyProc;
		psp[2].lParam = 0;
		psp[2].pszIcon = NULL;

		// Setup the property sheet.
		//..........................
		psh.dwSize = sizeof(PROPSHEETHEADER);
		psh.dwFlags = PSH_HASHELP | PSH_PROPSHEETPAGE | PSH_USEICONID | PSH_USECALLBACK; 
		psh.pfnCallback = PropertySheetProc;
		psh.hwndParent = hMainWindow;
		psh.hInstance = hInst;
		psh.pszCaption = (LPSTR)"Administrator Settings";
		psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
		psh.nStartPage = 0;
		psh.ppsp = (LPCPROPSHEETPAGE)&psp;
		psh.pszIcon = (LPCTSTR)lpszAppName;

		// Let's do it.
		//.............
		PropertySheet(&psh);

		// Make the new settings, if any, permanent.
		//..........................................
		cfg.V1.dwV3 = dwTempSettings;
		UpdateAdmin();
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Callback procedure for creating the property sheet and
// getting its HWND.
//........................................................
int CALLBACK PropertySheetProc(HWND hDlg, UINT uiMsg, LPARAM lParam)
{
	switch(uiMsg)
	{
		case PSCB_INITIALIZED:
		{
			hPropertySheet = hDlg;
		}
		break;
	}
	return(TRUE);
}

// CALLBACK procedure for the general admin settings dialog box.
//..............................................................
LRESULT CALLBACK AdminGeneralProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT		uCheck;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			CenterWindow(hPropertySheet,GetWindow(hPropertySheet,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_A_WIPE:
				case IDC_A_DELETE:
				case IDC_A_REPEAT:
				case IDC_A_MARGINALS:
				case IDC_A_COMPLETES:
				case IDC_A_TRUE:
				case IDC_A_CREATE:
				case IDC_A_CREATE_TOTP:
				case IDC_A_VIEW_TOTP:
				case IDC_A_NOTES:
				case IDC_A_CHAT:
				{
					if (!bPsChanged)
					{
						PropSheet_Changed(hPropertySheet,hDlg);
						bPsChanged = TRUE;
					}
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
    		switch (((NMHDR FAR *)lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{
					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_WIPE_ORIGINAL)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_WIPE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_WIPE_DELETE)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_DELETE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_CHANGE_REPEAT)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_REPEAT,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_CHANGE_MARGINALS)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_MARGINALS,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_CHANGE_COMPLETES)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_COMPLETES,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_AUTO_WIPE)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_TRUE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_NEW_SET_KEYS)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_CREATE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_CREATE_TOTP)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_CREATE_TOTP,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_VIEW_TOTP)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_VIEW_TOTP,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_NOTES)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_NOTES,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempGeneral & PERMIT_CHAT)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_CHAT,uCheck);

					// Return 0 to accept activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}	
				break;

				case PSN_APPLY:
				{
					dwTempSettings &= ~GENERAL_MASK;
					dwTempSettings |= dwTempGeneral;

					// Return no error.
					//.................
					SetWindowLong(hDlg,DWL_MSGRESULT,PSNRET_NOERROR);

					// Tell the property sheet to disable the apply button.
					//.....................................................
					PropSheet_UnChanged(hPropertySheet,hDlg);
					bPsChanged = FALSE;
				}
				break;

				case PSN_KILLACTIVE:
				{	
					// Get the changes we have made and store them in a temp variable.
					//................................................................
					dwTempGeneral = 0;

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_WIPE);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_WIPE_ORIGINAL;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_DELETE);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_WIPE_DELETE;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_REPEAT);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_CHANGE_REPEAT;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_MARGINALS);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_CHANGE_MARGINALS;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_COMPLETES);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_CHANGE_COMPLETES;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_TRUE);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_AUTO_WIPE;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_CREATE);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_NEW_SET_KEYS;
					}

					uCheck = IsDlgButtonChecked(hDlg, IDC_A_CREATE_TOTP);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_CREATE_TOTP;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_VIEW_TOTP);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_VIEW_TOTP;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_NOTES);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_NOTES;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_CHAT);
					if (uCheck == BST_CHECKED)
					{
						dwTempGeneral |= PERMIT_CHAT;
					}
					// Return FALSE to loose active status.
					//.....................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// All changes since last apply are cancelled.
					// Means we cancelled the procedure.
					//............................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
    	}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;
		
		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for admin public key ring settings dialog box.
//..................................................................
LRESULT CALLBACK AdminPublicKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT	uCheck;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_A_P_DELETE_K:
				case IDC_A_P_DELETE_S:
				case IDC_A_P_SIGN:
				case IDC_A_P_EXTRACT:
				case IDC_A_P_VIEW:
				case IDC_A_P_DISABLE:
				case IDC_A_P_OWNER:
				{
					if (!bPsChanged)
					{
						PropSheet_Changed(hPropertySheet,hDlg);
						bPsChanged = TRUE;
					}
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
    		switch (((NMHDR FAR *) lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{
					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_DELETE_PUBLIC)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_DELETE_K,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_DELETE_SIGS)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_DELETE_S,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_SIGN_PUBLIC_KEY)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_SIGN,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_EXTRACT_PUBLIC)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_EXTRACT,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_VIEW_PUB_RING)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_VIEW,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_DISABLE_PUBLIC)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_DISABLE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempPublic & PERMIT_EDIT_OWNER_TRUST)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_P_OWNER,uCheck);

					// Accept activation of this page.
					//................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}	
				break;

				case PSN_APPLY:
				{
					dwTempSettings &= ~PUBLIC_MASK;
					dwTempSettings |= dwTempPublic;

					// Return no error.
					//.................
					SetWindowLong(hDlg,DWL_MSGRESULT,PSNRET_NOERROR);

					// Tell the property sheet to disable the apply button.
					//.....................................................
					PropSheet_UnChanged(hPropertySheet,hDlg);
					bPsChanged = FALSE;
				}
				break;

				case PSN_KILLACTIVE:
				{	
					// Get the changes we made and store them in a temp variable.
					//...........................................................
					dwTempPublic = 0;

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_DELETE_K);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_DELETE_PUBLIC;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_DELETE_S);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_DELETE_SIGS;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_SIGN);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_SIGN_PUBLIC_KEY;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_EXTRACT);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_EXTRACT_PUBLIC;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_VIEW);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_VIEW_PUB_RING;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_DISABLE);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_DISABLE_PUBLIC;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_P_OWNER);
					if (uCheck == BST_CHECKED)
					{
						dwTempPublic |= PERMIT_EDIT_OWNER_TRUST;
					}
					// Return OK to loose activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// We cancelled the procedure. All changes since last
					// apply do not count.
					//...................................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
    	}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;
		
		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for admin secret key ring settins dialog box.
//.................................................................
LRESULT CALLBACK AdminSecretKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT	uCheck;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_A_S_VIEW:
				case IDC_A_S_COMPONENTS:
				case IDC_A_S_DELETE:
				case IDC_A_S_CHANGE:
				case IDC_A_S_EXTRACT:
				case IDC_A_S_ID:
				case IDC_A_S_COMPROMISE:
				{
					if (!bPsChanged)
					{
						PropSheet_Changed(hPropertySheet,hDlg);
						bPsChanged = TRUE;
					}
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
    		switch (((NMHDR FAR *) lParam)->code) 
    		{
				// Initialize the checkboxes.
				//...........................
				case PSN_SETACTIVE:
				{	
					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_VIEW_SEC_RING)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_VIEW,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_VIEW_SEC_COMPON)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_COMPONENTS,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_DELETE_SECRET)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_DELETE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_CHANGE_PASS)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_CHANGE,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_EXTRACT_SECRET)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_EXTRACT,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_ADD_USER_ID)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_ID,uCheck);

					uCheck = BST_UNCHECKED;
					if (dwTempSecret & PERMIT_COMPROMISE)
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_A_S_COMPROMISE,uCheck);

					// Accept activation of this page.
					//................................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}	
				break;

				case PSN_APPLY:
				{
					dwTempSettings &= ~SECRET_MASK;
					dwTempSettings |= dwTempSecret;

					// Return no error.
					//.................
					SetWindowLong(hDlg,DWL_MSGRESULT,PSNRET_NOERROR);

					// Tell the property sheet to disable the apply button.
					//.....................................................
					PropSheet_UnChanged(hPropertySheet,hDlg);
					bPsChanged = FALSE;
				}
				break;

				case PSN_KILLACTIVE:
				{	
					dwTempSecret = 0;

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_VIEW);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_VIEW_SEC_RING;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_COMPONENTS);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_VIEW_SEC_COMPON;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_DELETE);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_DELETE_SECRET;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_CHANGE);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_CHANGE_PASS;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_EXTRACT);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_EXTRACT_SECRET;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_ID);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_ADD_USER_ID;
					}

					uCheck = IsDlgButtonChecked(hDlg,IDC_A_S_COMPROMISE);
					if (uCheck == BST_CHECKED)
					{
						dwTempSecret |= PERMIT_COMPROMISE;
					}

					// Return OK to loose activation.
					//...............................
					SetWindowLong(hDlg,DWL_MSGRESULT,FALSE);
				}
				break;

				case PSN_RESET:
				{
					// All changes since last apply are cancelled.
					// We cancelled the procedure.
					//............................................
				}
				break;

				case PSN_HELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
    	}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;
		
		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Delete the admin account.
//..........................
VOID DeleteAdminAccount()
{
	int			iResult;
	DWORD		dwOldHelpTopic;
	BOOL		bSignedOK;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_DELETEADMIN);
	bSignedOK = bSignedIn;

	// If we are not signed in, we have too.
	//......................................
	if (!bSignedIn)
	{
		bSignedOK = AdminSignIn(FALSE);
	}
	if (bSignedOK)
	{
		// If we are signed in we can now delete the account.
		// Ask for confirmation first.
		//...................................................
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,IDS_CONFIRMDELETEAD,
								 MB_ICONQUESTION | MB_HELP | MB_YESNO,MB_ICONQUESTION,0);
		if (iResult == IDYES)
		{
			cfg.V1.dwLength = 0;
			cfg.V1.dwV3 = 0;
			ZeroMemory(&cfg.V1.AdminName,sizeof(cfg.V1.AdminName));
			ZeroMemory(&cfg.V1.RandomData,sizeof(cfg.V1.RandomData));
			ZeroMemory(&cfg.V1.V2,sizeof(cfg.V1.V2));
			bSignedIn = FALSE;
			bAa = FALSE;
			bRestrictionsInEffect = FALSE;
			bRemainSignedIn = FALSE;
			bNeedUKey = TRUE;
			SetAdminMenu(TRUE);
			UpdateAdmin();
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_ADMINDELETED,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);

			// Set the state of the admin sign in toolbar button.
			//...................................................
			SendMessage(hMyToolBar,TB_CHECKBUTTON,IDM_SIGN_IN,(LPARAM)MAKELONG(FALSE,0));
			SendMessage(hMyToolBar,TB_SETSTATE,IDM_SIGN_IN,TBSTATE_INDETERMINATE);
		}
	}

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Sign in to the admin account.
//..............................
BOOL AdminSignIn(BOOL bShowMsg)
{
	BOOL		bSignedInOK = FALSE;
	int			iDlgResult;
	DWORD		dwOldHelpTopic;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;
	bRemainSignedIn = FALSE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_ADMINSIGNIN);

	iDlgResult = DialogBox(hInst,TEXT("SIGNINADMIN"),hMainWindow,(DLGPROC)SignInAdminProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto SignInEnd;
	}
	EmptyTheMessageQue();

	if (iDlgResult == IDOK)
	{
		if (bShowMsg)
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_SIGNEDINOK,MB_ICONINFORMATION | MB_OK,
						   MB_ICONINFORMATION,0);
		}
		bSignedInOK = TRUE;
	}

	SignInEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
	return(bSignedInOK);
}

// CALLBACK procedure for signing into your Administator Account dialog box.
//..........................................................................
LRESULT CALLBACK SignInAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iResult;
	DWORD		dwLength;
	DWORD		dwLength1;
	UINT		uCheck;
	BOOL		bTBState;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the administrator name and pass phrases.
			//.................................................................
			SendDlgItemMessage(hDlg,IDC_ADMINNSI,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PPSI,EM_SETLIMITTEXT,(WPARAM) 255,0);

			ZeroMemory(&szName,sizeof(szName));
			ZeroMemory(&szPP,sizeof(szPP));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			if (dwProcedure == IDM_SIGN_IN)
			{	
				// Set and then disable the remain signed in checkbox.
				//....................................................
				CheckDlgButton(hDlg,IDC_REMAINSIGNEDIN,BST_CHECKED);
				EnableWindow(GetDlgItem(hDlg,IDC_REMAINSIGNEDIN),FALSE);
				bRemainSignedIn = TRUE;
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_ADMINNSI));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					ADMIN_NAME		A1;

					CopyMemory(&A1,&cfg.V1,sizeof(ADMIN_NAME));

					// Get the name.
					//..............
					GetDlgItemText(hDlg,IDC_ADMINNSI,(LPTSTR)&szTemp1,MAX_PATH);
					
					// Now get the password.
					//......................
					GetDlgItemText(hDlg,IDC_PPSI,(LPTSTR)&szTemp2,MAX_PATH);

					dwLength = lstrlen((LPCTSTR)&szTemp2);
					dwLength1 = lstrlen((LPCTSTR)&szTemp1);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLength
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLength; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPP[dwV] = szTemp2[dwV];
							}
						}
					}
					// Now do the admin name.
					//.......................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLength1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLength1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szName[dwV] = szTemp1[dwV];
							}
						}
					}
					if (dwLength == 0 || dwLength1 == 0)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNIN,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_ADMINNSI));
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						ZeroMemory(&szPP,MAX_PATH);
						ZeroMemory(&szName,sizeof(szName));
						break;
					}
					// Decrypt the admin name and see if we have a match.
					//...................................................
					DecipherSecretComponents((LPBYTE)&szPP,(LPBYTE)&A1.AdminName,
											  dwLength,MAX_PATH);

					// Compare the entered admin name with the decrypted one.
					//.......................................................
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&A1.AdminName,-1,
										    (LPCTSTR)&szName,-1);

					ZeroMemory(&A1,sizeof(ADMIN_NAME));
					ZeroMemory(&szPP,MAX_PATH);
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					ZeroMemory(&szName,sizeof(szName));
					SetDlgItemText(hDlg,IDC_ADMINNSI,lpszNullString);
					SetDlgItemText(hDlg,IDC_PPSI,lpszNullString);

					if (iResult != CSTR_EQUAL)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNIN,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_ADMINNSI));
						break;
					}
					// Update the admin menu.
					//.......................
					if (bRemainSignedIn)
					{
						bSignedIn = TRUE;
						bRestrictionsInEffect = FALSE;
						bTBState = TRUE;
					}
					else
					{
						bSignedIn = FALSE;
						bRestrictionsInEffect = TRUE;
						bTBState = FALSE;
					}
					SendMessage(hMyToolBar,TB_CHECKBUTTON,IDM_SIGN_IN,
							   (LPARAM)MAKELONG(bTBState,0));
					SetAdminMenu(FALSE);
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_ADMINNSITEXT:
				{
					VirtualKeyboard(hDlg,IDC_ADMINNSI,(LPBYTE)&szName,sizeof(szName));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNSI));
				}
				break;

				case IDC_PPSITEXT:
				{
					VirtualKeyboard(hDlg,IDC_PPSI,(LPBYTE)&szPP,sizeof(szPP));
					SetFocus(GetDlgItem(hDlg,IDC_PPSI));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_ADMINNSI,lpszNullString);
					SetDlgItemText(hDlg,IDC_PPSI,lpszNullString);
					ZeroMemory(&szName,MAX_PATH);
					ZeroMemory(&szPP,MAX_PATH);
					SendMessage(hMyToolBar,TB_CHECKBUTTON,IDM_SIGN_IN,
							   (LPARAM)MAKELONG(FALSE,0));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_ADMINCLEAR:
				{
					SetDlgItemText(hDlg,IDC_ADMINNSI,lpszNullString);
					SetDlgItemText(hDlg,IDC_PPSI,lpszNullString);
					ZeroMemory(&szName,MAX_PATH);
					ZeroMemory(&szPP,MAX_PATH);
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNSI));
				}
				break;

				case IDC_REMAINSIGNEDIN:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_REMAINSIGNEDIN);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bRemainSignedIn = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bRemainSignedIn = TRUE;
					}
					CheckDlgButton(hDlg,IDC_REMAINSIGNEDIN,uCheck);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Sign out of the admin account.
//...............................
VOID AdminSignOut()
{
	bSignedIn = FALSE;
	bRemainSignedIn = FALSE;
	bRestrictionsInEffect = TRUE;
	SetAdminMenu(FALSE);

	SendMessage(hMyToolBar,TB_CHECKBUTTON,IDM_SIGN_IN,(LPARAM)MAKELONG(FALSE,0));

	MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_SIGNEDOUTOK,MB_ICONINFORMATION | MB_OK,
				   MB_ICONINFORMATION,0);
}

// Change admin account information.
//..................................
VOID ChangeAdminAccount()
{
	int				iDlgResult;
	DWORD			dwOldHelpTopic;
	BOOL			bSignedOK;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_CHANGEADMINACCOUNT);
	bSignedOK = bSignedIn;

	// If we are not signed in, we have too.
	//......................................
	if (!bSignedIn)
	{
		bSignedOK = AdminSignIn(FALSE);
	}
	if (!bSignedOK)
	{
		goto ChangeEnd;
	}
	// Display the change admininstrator information dialog box.
	//..........................................................
	iDlgResult = DialogBox(hInst,TEXT("CHANGEADMIN"),hMainWindow,(DLGPROC)ChangeAdminProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ChangeEnd;
	}
	// We changed the account information.
	//....................................
	if (iDlgResult == IDOK)
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_CHANGEOK,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}

  ChangeEnd:
	
	EmptyTheMessageQue();
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for change Administator Account dialog box.
//...............................................................
LRESULT CALLBACK ChangeAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	int			iResult;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the administrator name and pass phrases.
			//.................................................................
			SendDlgItemMessage(hDlg,IDC_ADMINNAME,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP1,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP2,EM_SETLIMITTEXT,(WPARAM) 255,0);

			CopyMemory(&V2,&cfg.V1,sizeof(ADMIN_NAME));
			ZeroMemory(&V2.AdminName,sizeof(V2.AdminName));
			V2.dwLength = 0;
			ZeroMemory(&szV5,sizeof(szV5));
			ZeroMemory(&szV6,sizeof(szV6));
			ZeroMemory(&szTemp,sizeof(szTemp));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Check out the values and make sure they are OK.
					//................................................
					GetDlgItemText(hDlg,IDC_ADMINNAME,(LPTSTR)&szTemp,MAX_PATH);
					V2.dwLength = lstrlen((LPCTSTR)&szTemp);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,V2.dwLength
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < V2.dwLength; dwV++)
						{
							if ((BYTE)szTemp[dwV] != DEFAULT_CHAR)
							{
								V2.AdminName[dwV] = szTemp[dwV];
							}
						}
					}
					if (V2.dwLength < 6 || V2.dwLength > 255)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_ADMINNAMESHORT,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_ADMINNAME,lpszNullString);
						ZeroMemory(&szTemp,sizeof(szTemp));
						ZeroMemory(&V2.AdminName,sizeof(V2.AdminName));
						SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
						break;
					}
					// Now check out the passwords.
					//.............................
					GetDlgItemText(hDlg,IDC_PP1,(LPTSTR)&szTemp1,MAX_PATH);
					GetDlgItemText(hDlg,IDC_PP2,(LPTSTR)&szTemp2,MAX_PATH);

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szV5[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szV6[dwV] = szTemp2[dwV];
							}
						}
					}
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szV5,-1,
										    (LPCTSTR)&szV6,-1);
					if (iResult != CSTR_EQUAL ||
					   (iResult == CSTR_EQUAL && (dwLengthPP1 < 6 || dwLengthPP1 > 255)))
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_ADMINPPNOTEQ,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_PP1,lpszNullString);
						SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						ZeroMemory(&szV5,sizeof(szV5));
						ZeroMemory(&szV6,sizeof(szV6));
						SetFocus(GetDlgItem(hDlg,IDC_PP1));
						break;
					}
					// Encrypt the administrator's name and store it in the registry.
					//...............................................................
					GetRandomBits((CFB_LENGTH*8),&V2.RandomData);
					EncipherSecretComponents((LPBYTE)&szV5,(LPBYTE)&V2.AdminName,
											 (DWORD)dwLengthPP1,MAX_PATH);

					// Update the admin registry entries.
					//...................................
					CopyMemory(&cfg.V1,&V2,sizeof(ADMIN_NAME));
					ZeroMemory(&V2,sizeof(ADMIN_NAME));
					UpdateAdmin();
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_ADMINNAMETEXT:
				{
					VirtualKeyboard(hDlg,IDC_ADMINNAME,(LPBYTE)&V2.AdminName,
									sizeof(V2.AdminName));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
				}
				break;

				case IDC_PPTEXT1:
				{
					VirtualKeyboard(hDlg,IDC_PP1,(LPBYTE)&szV5,sizeof(szV5));
					SetFocus(GetDlgItem(hDlg,IDC_PP1));
				}
				break;

				case IDC_PPTEXT2:
				{
					VirtualKeyboard(hDlg,IDC_PP2,(LPBYTE)&szV6,sizeof(szV6));
					SetFocus(GetDlgItem(hDlg,IDC_PP2));
				}
				break;

				case IDCANCEL:
				{
					ZeroMemory(&V2,sizeof(ADMIN_NAME));
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_ADMINCLEAR:
				{
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Create an Administrator Account.
//.................................
VOID CreateAdminAccount()
{
	int				iDlgResult;
	DWORD			dwOldHelpTopic;
	BOOL			bTBState;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;
	bRemainSignedIn = FALSE;
	bSignedIn = FALSE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_CREATEADMINACCOUNT);

	iDlgResult = DialogBox(hInst,TEXT("CREATEADMIN"),hMainWindow,(DLGPROC)CreateAdminProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CreateEnd;
	}
	if (iDlgResult == IDOK)
	{
		// We have a good account created.
		//................................
		bAa = TRUE;
		SetAdminMenu(FALSE);

		// Set the state of the toolbar.
		//..............................
		SendMessage(hMyToolBar,TB_SETSTATE,IDM_SIGN_IN,TBSTATE_ENABLED);

		bTBState = FALSE;

		if (bSignedIn)
		{
			bTBState = TRUE;
		}
		SendMessage(hMyToolBar,TB_CHECKBUTTON,IDM_SIGN_IN,(LPARAM)MAKELONG(bTBState,0));

		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_CREATEOK,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}

  CreateEnd:
	
	EmptyTheMessageQue();
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for create Administator Account dialog box.
//...............................................................
LRESULT CALLBACK CreateAdminProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT		uCheck;
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	int			iResult;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the administrator name and pass phrases.
			//.................................................................
			SendDlgItemMessage(hDlg,IDC_ADMINNAME,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP1,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP2,EM_SETLIMITTEXT,(WPARAM) 255,0);

			ZeroMemory(&cfg.V1,sizeof(ADMIN_NAME)-4);
			ZeroMemory(&szV5,sizeof(szV5));
			ZeroMemory(&szV6,sizeof(szV6));
			ZeroMemory(&szTemp,sizeof(szTemp));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Check out the values and make sure they are OK.
					//................................................
					GetDlgItemText(hDlg,IDC_ADMINNAME,(LPTSTR)&szTemp,MAX_PATH);
					cfg.V1.dwLength = lstrlen((LPCTSTR)&szTemp);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,cfg.V1.dwLength
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < cfg.V1.dwLength; dwV++)
						{
							if ((BYTE)szTemp[dwV] != DEFAULT_CHAR)
							{
								cfg.V1.AdminName[dwV] = szTemp[dwV];
							}
						}
					}
					if (cfg.V1.dwLength < 6 || cfg.V1.dwLength > 255)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_ADMINNAMESHORT,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
						ZeroMemory(&szTemp,sizeof(szTemp));
						ZeroMemory(&cfg.V1.AdminName,sizeof(cfg.V1.AdminName));
						break;
					}
					// Now check out the passwords.
					//.............................
					GetDlgItemText(hDlg,IDC_PP1,(LPTSTR)&szTemp1,MAX_PATH);
					GetDlgItemText(hDlg,IDC_PP2,(LPTSTR)&szTemp2,MAX_PATH);

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szV5[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szV6[dwV] = szTemp2[dwV];
							}
						}
					}
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szV5,-1,
										   (LPCTSTR)&szV6,-1);
					if (iResult != CSTR_EQUAL ||
					   (iResult == CSTR_EQUAL && (dwLengthPP1 < 6 || dwLengthPP1 > 255)))
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_ADMINPPNOTEQ,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_PP1,lpszNullString);
						SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
						SetFocus(GetDlgItem(hDlg,IDC_PP1));
						break;
					}
					// Encrypt the administrator's name and store it in the registry.
					//...............................................................
					GetRandomBits((CFB_LENGTH*8),&cfg.V1.RandomData);
					EncipherSecretComponents((LPBYTE)&szV5,(LPBYTE)&cfg.V1.AdminName,
											 (DWORD)dwLengthPP1,MAX_PATH);

					// Indicate that we have a valid administrator account.
					//.....................................................
					bAa = TRUE;
					if (bRemainSignedIn)
					{
						bSignedIn = TRUE;
						bRestrictionsInEffect = FALSE;
					}
					else
					{
						bSignedIn = FALSE;
						bRestrictionsInEffect = TRUE;
					}
					bNeedUKey = TRUE;

					// Update the admin registry entries.
					//...................................
					UpdateAdmin();
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_ADMINNAMETEXT:
				{
					VirtualKeyboard(hDlg,IDC_ADMINNAME,(LPBYTE)&cfg.V1.AdminName,
									sizeof(cfg.V1.AdminName));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
				}
				break;

				case IDC_PPTEXT1:
				{
					VirtualKeyboard(hDlg,IDC_PP1,(LPBYTE)&szV5,sizeof(szV5));
					SetFocus(GetDlgItem(hDlg,IDC_PP1));
				}
				break;

				case IDC_PPTEXT2:
				{
					VirtualKeyboard(hDlg,IDC_PP2,(LPBYTE)&szV6,sizeof(szV6));
					SetFocus(GetDlgItem(hDlg,IDC_PP2));
				}
				break;

				case IDCANCEL:
				{
					ZeroMemory(&cfg.V1,sizeof(ADMIN_NAME));
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_ADMINCLEAR:
				{
					ClearAdminEntries(hDlg);
					ZeroMemory(&szV5,MAX_PATH);
					ZeroMemory(&szV6,MAX_PATH);
					SetFocus(GetDlgItem(hDlg,IDC_ADMINNAME));
				}
				break;

				case IDC_REMAINSIGNEDIN:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_REMAINSIGNEDIN);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bRemainSignedIn = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bRemainSignedIn = TRUE;
					}
					CheckDlgButton(hDlg,IDC_REMAINSIGNEDIN,uCheck);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Clear the admin entries.
//.........................
VOID ClearAdminEntries(HWND hDlg)
{
	SetDlgItemText(hDlg,IDC_ADMINNAME,lpszNullString);
	SetDlgItemText(hDlg,IDC_PP1,lpszNullString);
	SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
	ZeroMemory(&szTemp,sizeof(szTemp));
	ZeroMemory(&szTemp1,sizeof(szTemp1));
	ZeroMemory(&szTemp2,sizeof(szTemp2));
}

// Check out the administrator account. and set the final status
// of the menu items. 0 = personal version, 1 = registered, 2 = 
// registry keys not present.
//...............................................................
DWORD CheckAdminAccount()
{
	LRESULT		lResult;
	HKEY		hKey = 0;
	DWORD		dwSize;
	DWORD		dwDisposition;
	DWORD		dwStatus = 2;

	// Open the password key. If it is not there create it.
	// This should not happen unless it is removed or the
	// registry is corrupted.
	//.....................................................
	if (!bRemoveableMedia || bFirstTimeRead)
	{
		ZeroMemory(&cfg.P1,sizeof(PASSWORD));

		lResult = RegCreateKeyEx(HKEY_CLASSES_ROOT,(LPCTSTR)lpPW,0,"",
								 REG_OPTION_NON_VOLATILE,KEY_WRITE | KEY_QUERY_VALUE,
								 NULL,&hKey,&dwDisposition);
		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
		// If we created the key we have to set the values.
		//.................................................
		if (dwDisposition == REG_CREATED_NEW_KEY)
		{
			lResult = RegSetValueEx(hKey,lpszP1,0,REG_BINARY,(BYTE *)&cfg.P1,sizeof(PASSWORD));
			if (lResult != ERROR_SUCCESS)
			{
				goto CheckEnd;
			}
		}
		else
		{
			// Get the encrypted password.
			//............................
			dwSize = sizeof(PASSWORD);;
			lResult = RegQueryValueEx(hKey,lpszP1,NULL,NULL,(LPBYTE)&cfg.P1,&dwSize);
			if (lResult != ERROR_SUCCESS)
			{
				goto CheckEnd;
			}
		}
		RegCloseKey(hKey);
		hKey = 0;

		// Open the admin key. If it is not there return not present.
		// This should not happen unless it is removed or the
		// registry is corrupted.
		//...........................................................
		lResult = RegOpenKeyEx(HKEY_CLASSES_ROOT,(LPCTSTR)lpA1,0,KEY_QUERY_VALUE,&hKey);
		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
		// Get the encrypted administrator name.
		//......................................
		dwSize = sizeof(ADMIN_NAME);;
		lResult = RegQueryValueEx(hKey,lpszV1,NULL,NULL,(LPBYTE)&cfg.V1,&dwSize);
		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
		RegCloseKey(hKey);
		hKey = 0;
	}
	// If we are registered, return 1.
	//................................
	if (cfg.V1.iV4 == 1)
	{
		dwStatus = 1;
		goto CheckEnd;
	}
	// Return status of program.
	//..........................
	if (!bProgramRegistered)
	{
		dwStatus = 0;
		cfg.V1.iV4 = 0;
	}
	else
	{
		dwStatus = 1;
		cfg.V1.iV4 = 1;
	}

	CheckEnd:

	if (hKey)
	{
		RegCloseKey(hKey);
	}
	// See if we have an account created already.
	//...........................................
	if (cfg.V1.dwLength >= 6)
	{
		bAa = TRUE;
	}
	// If we have an active account and are not signed in
	// the restictions are in effect.
	//...................................................
	if (bAa && !bSignedIn)
	{
		bRestrictionsInEffect = TRUE;
	}
	// Do we have a universal designated yet? Required.
	//.................................................
	if (bAa)
	{
		bNeedUKey = FALSE;

		__asm
		{
			mov		edi,offset byte ptr cfg.V1
			cmp		dword ptr [edi],0
			jne		L1
			cmp		dword ptr [edi+4],0
			jne		L1
			mov		bNeedUKey,1
		  L1:
		}
	}
	// Update the entries in case any have changed.
	//.............................................
	UpdateAdmin();

	return(dwStatus);
}

// Update the admin and trial period registry entries.
//....................................................
VOID UpdateAdmin()
{
	LRESULT		lResult;
	HKEY		hKey = 0;

	if (!bRemoveableMedia || dwRemoveableInstalled == REMOVEABLE_INSTALLED)
	{
		lResult = RegOpenKeyEx(HKEY_CLASSES_ROOT,(LPCTSTR)lpA1,0,KEY_SET_VALUE,&hKey);
		if (lResult != ERROR_SUCCESS)
		{
			goto UpdateEnd;
		}
		// Set the admin name data.
		//.........................
		lResult = RegSetValueEx(hKey,lpszV1,0,REG_BINARY,(BYTE *)&cfg.V1,sizeof(ADMIN_NAME));
		if (lResult != ERROR_SUCCESS)
		{
			goto UpdateEnd;
		}
		RegCloseKey(hKey);
		hKey = 0;

		// Update the password.
		//.....................
		lResult = RegOpenKeyEx(HKEY_CLASSES_ROOT,(LPCTSTR)lpPW,0,KEY_SET_VALUE,&hKey);
		if (lResult != ERROR_SUCCESS)
		{
			goto UpdateEnd;
		}
		RegSetValueEx(hKey,lpszP1,0,REG_BINARY,(BYTE *)&cfg.P1,sizeof(PASSWORD));
	
		UpdateEnd:

		if (hKey)
		{
			RegCloseKey(hKey);
		}
	}
	// Write the cfg file data.
	//.........................
	if (bRemoveableMedia)
	{
		WriteMyCfgFile();
	}
}

// Set or change a password required to run the program.
//......................................................
VOID SetMyPassword()
{
	int			iDlgResult = 0;
	int			iResult;
	DWORD		dwOldHelpTopic;

	dwOldHelpTopic = ChangeHelpTopic(IDH_PASSWORD);

	if (cfg.P1.dwLength == 0)
	{
		// We have to get a new password.
		//...............................
		iDlgResult = DialogBox(hInst,TEXT("SETPASSWORD"),hMainWindow,
							  (DLGPROC)SetPasswordProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................	
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
	}
	else
	{
		// Display a message asking if they really want to change it.
		//...........................................................
		iResult = MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_ASKCHANGEPP,
							     MB_ICONINFORMATION | MB_OKCANCEL | MB_HELP,
								 MB_ICONINFORMATION,0);
		if (iResult == IDCANCEL)
		{
			goto SetEnd;
		}
		// We have to change a password. First we have to sign in again.
		//..............................................................
		iDlgResult = DialogBox(hInst,TEXT("SIGNINPASSWORD"),hMainWindow,
							  (DLGPROC)SignInPasswordProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................	
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto SetEnd;
		}
		if (iDlgResult == IDCANCEL)
		{
			goto SetEnd;
		}
		// We have to get a new password.
		//...............................
		iDlgResult = DialogBox(hInst,TEXT("SETPASSWORD"),hMainWindow,
							  (DLGPROC)SetPasswordProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................	
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
	}
	if (iDlgResult == IDOK)
	{
		// We successfully set or changed our password.
		//.............................................
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_PSWDCHNGOK,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	SetEnd:

	ChangeHelpTopic(dwOldHelpTopic);
}

// Check on the password. If one is not set, ask if we want to set one.
// If one is set, get it and see if it is correct. Return TRUE if there
// is an error.
//.....................................................................
BOOL CheckPassword()
{
	BOOL		bError = FALSE;
	int			iDlgResult;
	DWORD		dwMyHelpTopic;

	dwMyHelpTopic = ChangeHelpTopic(IDH_PASSWORD);

	// If we do not have a password set and we can ask, ask.
	//......................................................
	if (cfg.P1.dwLength == 0 && !cfg.P1.bDoNotAsk)
	{
		iDlgResult = DialogBox(hInst,TEXT("ASKPASSWORD"),hMainWindow,
							  (DLGPROC)AskPasswordProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................	
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto CheckEnd;
		}
		// If we said no, just update the password info for the check button.
		//...................................................................
		if (iDlgResult == IDC_PWNO)
		{
			UpdateAdmin();
			goto CheckEnd;
		}
		else
		{
			// We said yes, go and get a password.
			//....................................
			iDlgResult = DialogBox(hInst,TEXT("SETPASSWORD"),hMainWindow,
								  (DLGPROC)SetPasswordProc);

			// See if we had a system error in creating the dialog box.
			//.........................................................	
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			}
		}
	}
	else if (cfg.P1.dwLength > 0)
	{
		// We have a password. Get it and see if it is correct.
		//.....................................................
		iDlgResult = DialogBox(hInst,TEXT("SIGNINPASSWORD"),hMainWindow,
							  (DLGPROC)SignInPasswordProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................	
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			bError = TRUE;
		}
		if (iDlgResult == IDCANCEL)
		{
			bError = TRUE;
		}
	}

	CheckEnd:

	ChangeHelpTopic(dwMyHelpTopic);

	return(bError);
}

// CALLBACK procedure for signing into tscg.
//..........................................
LRESULT CALLBACK SignInPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	int			iResult;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the passwords.
			//.......................................
			SendDlgItemMessage(hDlg,IDC_PPTSCG,EM_SETLIMITTEXT,(WPARAM) 255,0);

			ZeroMemory(&szV5,sizeof(szV5));
			ZeroMemory(&szTemp,sizeof(szTemp));
			
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));

			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					PASSWORD		P2;

					CopyMemory(&P2,&cfg.P1,sizeof(PASSWORD));

					// Get the password.
					//..................
					GetDlgItemText(hDlg,IDC_PPTSCG,(LPTSTR)&szTemp,MAX_PATH);
					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp[dwV] != DEFAULT_CHAR)
							{
								szV5[dwV] = szTemp[dwV];
							}
						}
					}
					ZeroMemory(&szTemp,sizeof(szTemp));

					if (dwLengthPP1 == 0)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNINTSCG,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						ZeroMemory(&szV5,sizeof(szV5));
						SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
						break;
					}
					// Decrypt the password and see if we have a match.
					//.................................................
					DecipherSecretComponents((LPBYTE)&szV5,(LPBYTE)&P2.Password,
										      dwLengthPP1,MAX_PATH);

					// Compare the entered password with the decrypted one.
					//.....................................................
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szV5,-1,
										   (LPCTSTR)&P2.Password,-1);

					ZeroMemory(&P2,sizeof(P2));
					ZeroMemory(&szV5,sizeof(szV5));
					SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);

					if (iResult != CSTR_EQUAL)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNINTSCG,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
						break;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					// Popup the virtual keyboard.
					//............................
					VirtualKeyboard(hDlg,IDC_PPTSCG,(LPBYTE)&szV5,sizeof(szV5));
					SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
				}
				break; 

				case IDC_PPTSCGCLEAR:
				{
					SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);
					ZeroMemory(&szV5,sizeof(szV5));
					SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);
					ZeroMemory(&szV5,sizeof(szV5));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for setting your password.
//..............................................
LRESULT CALLBACK SetPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	PASSWORD	P2;
	int			iResult;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the passwords.
			//.......................................
			SendDlgItemMessage(hDlg,IDC_PPTSCG,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PPTSCG1,EM_SETLIMITTEXT,(WPARAM) 255,0);

			ZeroMemory(&szV5,sizeof(szV5));
			ZeroMemory(&szV6,sizeof(szV6));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));

			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					ZeroMemory(&P2,sizeof(P2));

					P2.bDoNotAsk = cfg.P1.bDoNotAsk;

					// Check out the passwords.
					//.........................
					GetDlgItemText(hDlg,IDC_PPTSCG,(LPTSTR)&szTemp1,MAX_PATH);
					GetDlgItemText(hDlg,IDC_PPTSCG1,(LPTSTR)&szTemp2,MAX_PATH);

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szV5[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szV6[dwV] = szTemp2[dwV];
							}
						}
					}
					// If both are 0 length clear the password.
					//.........................................
					if (dwLengthPP1 != 0 || dwLengthPP2 != 0)
					{
						iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szV5,-1,
											   (LPCTSTR)&szV6,-1);
						if (iResult != CSTR_EQUAL ||
						   (iResult == CSTR_EQUAL && (dwLengthPP1 < 6 || dwLengthPP1 > 255)))
						{
							MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_TSCGPPNOTEQ,
										   MB_ICONINFORMATION | MB_OK | MB_HELP,
										   MB_ICONINFORMATION,0);
							SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);
							SetDlgItemText(hDlg,IDC_PPTSCG1,lpszNullString);
							ZeroMemory(&szV5,sizeof(szV5));
							ZeroMemory(&szV6,sizeof(szV6));
							ZeroMemory(&szTemp1,sizeof(szTemp1));
							ZeroMemory(&szTemp2,sizeof(szTemp2));
							SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
							break;
						}
						else if (iResult == CSTR_EQUAL)
						{
							// Encrypt the pass phrase and store it in the registry.
							//......................................................
							GetRandomBits((CFB_LENGTH*8),&P2.RandomData);
							CopyMemory(&P2.Password,&szV5,dwLengthPP1);
							P2.dwLength = dwLengthPP1;
							EncipherSecretComponents((LPBYTE)&szV5,(LPBYTE)&P2.Password,
													(DWORD)dwLengthPP1,MAX_PATH);
						}
					}
					CopyMemory(&cfg.P1,&P2,sizeof(PASSWORD));
					ZeroMemory(&P2,sizeof(PASSWORD));
					UpdateAdmin();
					ZeroMemory(&szV5,sizeof(szV5));
					ZeroMemory(&szV6,sizeof(szV6));
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					// Popup the virtual keyboard.
					//............................
					VirtualKeyboard(hDlg,IDC_PPTSCG,(LPBYTE)&szV5,sizeof(szV5));
					SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
				}
				break;

				case IDC_PPTSCGTEXT1:
				{
					VirtualKeyboard(hDlg,IDC_PPTSCG1,(LPBYTE)&szV6,sizeof(szV6));
					SetFocus(GetDlgItem(hDlg,IDC_PPTSCG1));
				}
				break;

				case IDC_PPTSCGCLEAR:
				{
					SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);
					SetDlgItemText(hDlg,IDC_PPTSCG1,lpszNullString);
					ZeroMemory(&szV5,sizeof(szV5));
					ZeroMemory(&szV6,sizeof(szV6));
					SetFocus(GetDlgItem(hDlg,IDC_PPTSCG));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_PPTSCG,lpszNullString);
					SetDlgItemText(hDlg,IDC_PPTSCG1,lpszNullString);
					ZeroMemory(&szV5,sizeof(szV5));
					ZeroMemory(&szV6,sizeof(szV6));
					ZeroMemory(&P2,sizeof(PASSWORD));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for checking on your password.
//..................................................
LRESULT CALLBACK AskPasswordProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT		uCheck;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_PWYES:
				{
					EndDialog(hDlg,IDC_PWYES);
				}
				break;

				case IDC_PWNO:
				{
					EndDialog(hDlg,IDC_PWNO);
				}
				break;

				case IDC_DONOTASKAGAIN:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_DONOTASKAGAIN);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						cfg.P1.bDoNotAsk = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						cfg.P1.bDoNotAsk = TRUE;
					}
					CheckDlgButton(hDlg,IDC_DONOTASKAGAIN,uCheck);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
